%% Tract-specific analysis of ALS spinal cord data
%  Regents of the University of Minnesota.
% This software is licensed under The MIT License.  
% How to cite: If you use this software for your work, please cite the following paper published in Communications Biology: 
% Pisharady, P.K., Eberly, L.E., Cheong, I. et al. Tract-specific analysis improves sensitivity of spinal cord diffusion MRI 
% to cross-sectional and longitudinal changes in amyotrophic lateral sclerosis. Commun Biol 3, 370 (2020). https://doi.org/10.1038/s42003-020-1093-z

%Comment or uncomment lines 21-23 and 58-61 depending on the tracts to be analyzed

clear all
close all
clc
exDir='/Users/pramod/CMRR/Data/ALS';% Data directory
dataDir  = fullfile(exDir, 'ALS_sct');
fileID = fopen(fullfile(exDir,'between_group_spine/Demographics_long_1yr.txt')); % Demographics file
C = textscan(fileID,'%s %s %s');
fclose(fileID);
len_C=length(C{1});
FA_C2_all=[];
sel_tracts=1:30; % use this for White Matter
%sel_tracts=[04 05 08 09 10 11 16 17 18 19 20 21 22 23 24 25 26 27];% Use this for descending tracts

for m=1:len_C 
        wc_wm_des_data=[];cst_data=[]; lemni_data=[]; post_data=[];
   % for kk=121:1:124 % use for whole cord
     for kk=0:30:90 % FOR INDIVIDUAL TRACTS
            cst_all=[];FA_Cn_cst=[];FA_Cn=[];
            wc_wm_des_all=[]; lemni_all=[];FA_Cn_lemni=[]; post_all=[];FA_Cn_post=[];
        for n=2:6
            dataPathCn  = fullfile(dataDir,strcat('/',C{1}{m},'/FA_C',num2str(n),'.xls'));
            FA = xlsread(dataPathCn);
         %   FA_Cn = FA(kk,4); % use for whole cord
            FA_Cn = mean(nonzeros(FA(kk+sel_tracts,4))); % for WM and descending tracks 
            FA_Cn_cst = mean(nonzeros(FA(kk+5:kk+6,4))); % for CST
            FA_Cn_lemni = mean(nonzeros(FA(kk+13:kk+14,4))); %for spinal lemniscus
            FA_Cn_post = mean(nonzeros(FA(kk+1:kk+4,4))); % for posterior column
            
            wc_wm_des_all=[wc_wm_des_all FA_Cn];%  for WC, WM, and descending tracks 
            cst_all=[cst_all FA_Cn_cst];
            lemni_all=[lemni_all FA_Cn_lemni];
            post_all=[post_all FA_Cn_post];
        end
        wc_wm_des=mean(wc_wm_des_all);
        cst=mean(cst_all);
        lemni=mean(lemni_all);
        post=mean(post_all);
        wc_wm_des_data=[wc_wm_des_data wc_wm_des];
        cst_data=[cst_data cst];
        lemni_data=[lemni_data lemni];
        post_data=[post_data post];
    end
wc_wm_des_fa_rd_md_ad(m,:)=wc_wm_des_data;
cst_fa_rd_md_ad(m,:)=cst_data;
lemni_fa_rd_md_ad(m,:)=lemni_data;
post_fa_rd_md_ad(m,:)=post_data;
end

fa_rd_md_ad=wc_wm_des_fa_rd_md_ad; % Use this for wc, wm, des.tracts. Change here for other tracts, as below
%fa_rd_md_ad=cst_fa_rd_md_ad; 
%fa_rd_md_ad=lemni_fa_rd_md_ad; 
%fa_rd_md_ad=post_fa_rd_md_ad; 

for i=1:size(fa_rd_md_ad,2)
  1000* [mean(fa_rd_md_ad(1:11,i)) mean(fa_rd_md_ad(12:22,i))]
    if (i==1)
        plot([mean(fa_rd_md_ad(1:11,i)) mean(fa_rd_md_ad(12:22,i))],'LineWidth',2,'Color',[0.3,.6,.1]);
        hold on
        boxplot([fa_rd_md_ad(1:11,i) fa_rd_md_ad(12:22,i)],'Color',[0.3,.6,.1],'PlotStyle','compact','BoxStyle','outline','Widths',.2);
        diff_cst(i,:)=(fa_rd_md_ad(1:11,i))-(fa_rd_md_ad(12:22,i));
    elseif (i==2)
        plot(1000*[mean(fa_rd_md_ad(1:11,i)) mean(fa_rd_md_ad(12:22,i))],'LineWidth',2,'Color',[.9,.1,.3]);
        boxplot(1000*[fa_rd_md_ad(1:11,i) fa_rd_md_ad(12:22,i)],'Color',[.9,.1,.3],'PlotStyle','compact','BoxStyle','outline','Widths',.2);
        diff_cst(i,:)=1000*((fa_rd_md_ad(1:11,i))-(fa_rd_md_ad(12:22,i)));
    elseif (i==3)
        plot(1000*[mean(fa_rd_md_ad(1:11,i)) mean(fa_rd_md_ad(12:22,i))], 'LineWidth',2,'Color',[.9,.6,.1]);
        boxplot(1000*[fa_rd_md_ad(1:11,i) fa_rd_md_ad(12:22,i)],'Color',[.9,.6,.1],'PlotStyle','compact','BoxStyle','outline','Widths',.2);
        diff_cst(i,:)=1000*((fa_rd_md_ad(1:11,i))-(fa_rd_md_ad(12:22,i)));
    else
        plot(1000*[mean(fa_rd_md_ad(1:11,i)) mean(fa_rd_md_ad(12:22,i))], 'LineWidth',2,'Color',[.1,.9,.9]);
        boxplot(1000*[fa_rd_md_ad(1:11,i) fa_rd_md_ad(12:22,i)],'Color',[.1,.9,.9],'PlotStyle','compact','BoxStyle','outline','Widths',.2);
        diff_cst(i,:)=1000*((fa_rd_md_ad(1:11,i))-(fa_rd_md_ad(12:22,i)));
    end
    
    hold on
    [h p]=ttest(fa_rd_md_ad(1:11,i)-fa_rd_md_ad(12:22,i))
    nout = sampsizepwr('t',[mean(fa_rd_md_ad(1:11,i)-fa_rd_md_ad(12:22,i)) std(fa_rd_md_ad(1:11,i)-fa_rd_md_ad(12:22,i))],1.5*mean(fa_rd_md_ad(1:11,i)-fa_rd_md_ad(12:22,i)),0.75)
end
    ylim([0 2.5])
    set(gca,'xtick',[])
    legend('FA','RD (x10^-^3)','MD (x10^-^3)','AD (x10^-^3)')
    set(gca,'xtick',[])